using System;
using MapTools;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using System.IO;
using System.Xml;
using System.Runtime.InteropServices;

namespace CreateShapefile
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	class Class1
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			//
			// TODO: Add code to start application here
			//
			
			WriteShapeFile(args);
		}

		static void WriteShapeFile(string[] args)
		{
			if (args==null || args.Length==0)
			{
				Console.Write("\nUsage:  CreateShapefile configuration_filename\n\nPress any key to exit");
				Console.ReadLine();
				return;
			}
			string fileName = args[0];
			if (!File.Exists(fileName))
			{
				Console.WriteLine("\nCould not find file: {0}\n\nPress any key to exit", fileName);
				Console.ReadLine();
				return;
			}

			XmlDocument doc = new XmlDocument();
			try
			{
				doc.Load(fileName);
			}
			catch(XmlException ex)
			{
				Console.WriteLine("\n" + ex.Message + "\n\nPress any key to exit");
				Console.ReadLine();
				return;
			}
			XmlNode node = doc.SelectSingleNode("configuration/connectString");
			if (node==null || !node.HasChildNodes || node.FirstChild.Value==null) return;

			string strConnect = node.FirstChild.Value;
			strConnect = XmlConvert.DecodeName(strConnect);
			
			node = doc.SelectSingleNode("configuration/table");
			if (node==null || !node.HasChildNodes || node.FirstChild.Value==null) return;
			string table = node.FirstChild.Value;

			node = doc.SelectSingleNode("configuration/xField");
			if (node==null || !node.HasChildNodes || node.FirstChild.Value==null) return;
			string xField = node.FirstChild.Value;

			node = doc.SelectSingleNode("configuration/yField");
			if (node==null || !node.HasChildNodes || node.FirstChild.Value==null) return;
			string yField = node.FirstChild.Value;

			node = doc.SelectSingleNode("configuration/output");
			if (node==null || !node.HasChildNodes || node.FirstChild.Value==null) return;
			string output = node.FirstChild.Value;
			if (output.ToUpper().EndsWith(".SHP")) 
				output = output.Substring(0, output.Length-4);


			StringBuilder sb = new StringBuilder();
			sb.Append("SELECT * FROM ")
				.Append(table)
				.Append(" WHERE ")
				.Append(xField)
				.Append(" IS NOT NULL AND ")
				.Append(yField)
				.Append(" IS NOT NULL");

			SqlConnection cn = new SqlConnection(strConnect);
			SqlCommand cm = new SqlCommand(sb.ToString(), cn);
			// Open Connection
			try 
			{
				cn.Open();
			}
			catch(SqlException ex)
			{
				Console.Write("Connection failed: " + ex.Message);
				Console.Write("\\nnPress any key to exit");
				Console.ReadLine();
				return;
			}

			// Execute command
			SqlDataReader dr = cm.ExecuteReader();

			ShapeLib.ShapeType shpType = ShapeLib.ShapeType.Point;

			// create shapefile
			IntPtr hShp = ShapeLib.SHPCreate(output, shpType);
			if (hShp.Equals(IntPtr.Zero))
			{
				Console.WriteLine("\nCould not create {0}.shp\nProbable cause: File is in use by EasyStreets\n\nPress any key to exit", output);
				Console.ReadLine();
				return;
			}
			
			int iShape=0;
			double[] xCoord = new double[1];
			double[] yCoord = new double[1];
			bool flag = true;

			IntPtr hDbf = IntPtr.Zero;
			DataTable dt = new DataTable();
			System.Collections.Hashtable ht = new System.Collections.Hashtable();
			while(dr.Read())
			{
				if (flag)
				{
					flag = false;
					// create dbase file
					hDbf = ShapeLib.DBFCreate(output);
					if (!hDbf.Equals(IntPtr.Zero))
					{
						dt = dr.GetSchemaTable();
						dt.Columns.Add("dBaseName");
					}
					int ordinal = 0;
					foreach (DataRow row in dt.Rows)
					{
						string name = row["ColumnName"].ToString().ToUpper();
						if (name.Length>10)
							name = name.Substring(0,10);
						int i = 0;
						while (ht.ContainsKey(name))
						{
							string iVal = (i++).ToString();
							if (name.Length + iVal.Length > 10)
								name = name.Substring(0, 10 - iVal.Length) + iVal;
							else
								name = name + iVal;
						}
						ht.Add(name, ordinal++);
						row["dBaseName"] = name;
						string type = row["DataType"].ToString();
						switch (type)
						{
							case "System.Int32":
							case "System.Int16":
								ShapeLib.DBFAddField(hDbf, name, ShapeLib.DBFFieldType.FTInteger, 16, 0);
								break;
							case "System.String":
								int len = Math.Min(255, int.Parse(row["ColumnSize"].ToString()));
								ShapeLib.DBFAddField(hDbf, name, ShapeLib.DBFFieldType.FTString, len,0);
								break;
							case "System.Boolean":
								ShapeLib.DBFAddField(hDbf, name, ShapeLib.DBFFieldType.FTLogical, 5,0);
								break;
							case "System.Double":
							case "System.Float":
								int prec = int.Parse(row["NumericPrecision"].ToString());
								int scale = int.Parse(row["NumericScale"].ToString());
								ShapeLib.DBFAddField(hDbf, name, ShapeLib.DBFFieldType.FTDouble, prec, scale);
								break;
							case "System.DateTime":
								ShapeLib.DBFAddField(hDbf, name, ShapeLib.DBFFieldType.FTInteger, 8, 0);
								break;
							default:
								ht.Remove(name);
								row["dBaseName"] = null;
								ordinal--;
								break;
						}
					}
				}
				
				if (dr[xField] is DBNull || dr[yField] is DBNull)
					continue;

				Console.Write("#");
				xCoord[0] = Double.Parse(dr[xField].ToString());
				yCoord[0] = Double.Parse(dr[yField].ToString());

				IntPtr pShp = ShapeLib.SHPCreateObject(shpType, -1, 0, null, null, 1, xCoord, yCoord, null, null);
				ShapeLib.SHPWriteObject(hShp, -1, pShp);
				ShapeLib.SHPDestroyObject(pShp);

				foreach (DataRow row in dt.Rows)
				{
					if (row["dBaseName"]==null)
						continue;

					int ordinal = (int)ht[row["dBaseName"].ToString()];
					string fieldName = row["ColumnName"].ToString();
					if (dr[fieldName] is DBNull)
						continue;

					switch (row["DataType"].ToString())
					{
						case "System.Int32":
						case "System.Int16":
							ShapeLib.DBFWriteIntegerAttribute(hDbf, iShape, ordinal, int.Parse(dr[fieldName].ToString()));
							break;
						case "System.String":
							ShapeLib.DBFWriteStringAttribute(hDbf, iShape, ordinal, dr[fieldName].ToString());
							break;
						case "System.Boolean":
							ShapeLib.DBFWriteLogicalAttribute(hDbf, iShape, ordinal, bool.Parse(dr[fieldName].ToString()));
							break;
						case "System.Double":
						case "System.Float":
							ShapeLib.DBFWriteDoubleAttribute(hDbf, iShape, ordinal, double.Parse(dr[fieldName].ToString()));
							break;
						case "System.DateTime":
							DateTime date = DateTime.Parse(dr[fieldName].ToString());
							ShapeLib.DBFWriteDateAttribute(hDbf, iShape, ordinal,date);
							break;
					}
				}
				iShape++;
			}
			// free resources
			ShapeLib.SHPClose(hShp);
			ShapeLib.DBFClose(hDbf);
			cn.Close();
			Console.Write("\nCreated shapefile with " + iShape.ToString() + " workorders");
			System.Threading.Thread.Sleep(3000);
		}
	}
}
