Attribute VB_Name = "mShapeLib"
Option Explicit

Public Type SHPInfo
    fpSHP As Long
    fpSHX As Long
    nShapeType As Long              '/* SHPT_* */
    nFileSize As Long               '/* SHP file */
    nRecords As Long
    nMaxRecords As Long
    panRecOffset As Long
    panRecSize As Long
    adBoundsMin(4) As Double
    adBoundsMax(4) As Double
    bUpdated As Long
    pabyRec As String
    nBufSize As Long
End Type

'/* -------------------------------------------------------------------- */
'/*      Shape types (nSHPType)                                          */
'/* -------------------------------------------------------------------- */
Public Const SHPT_NULL = 0
Public Const SHPT_POINT = 1
Public Const SHPT_ARC = 3
Public Const SHPT_POLYGON = 5
Public Const SHPT_MULTIPOINT = 8
Public Const SHPT_POINTZ = 11
Public Const SHPT_ARCZ = 13
Public Const SHPT_POLYGONZ = 15
Public Const SHPT_MULTIPOINTZ = 18
Public Const SHPT_POINTM = 21
Public Const SHPT_ARCM = 23
Public Const SHPT_POLYGONM = 25
Public Const SHPT_MULTIPOINTM = 28
Public Const SHPT_MULTIPATCH = 31


'/* -------------------------------------------------------------------- */
'/*      Part types - everything but SHPT_MULTIPATCH just uses           */
'/*      SHPP_RING.                                                      */
'/* -------------------------------------------------------------------- */

Public Const SHPP_TRISTRIP = 0
Public Const SHPP_TRIFAN = 1
Public Const SHPP_OUTERRING = 2
Public Const SHPP_INNERRING = 3
Public Const SHPP_FIRSTRING = 4
Public Const SHPP_RING = 5

'/* -------------------------------------------------------------------- */
'/*      SHPObject - represents on shape (without attributes) read       */
'/*      from the .shp file.                                             */
'/* -------------------------------------------------------------------- */
Public Type SHPObject
    nSHPType As Long
    nShapeId  As Long '/* -1 is unknown/unassigned */
    nParts As Long
    panPartStart As Long
    panPartType As Long
    nVertices As Long
    padfX As Long  ' pointer to array of doubles
    padfY As Long  ' use MoveMemory to recover object from ptr
    padfZ As Long
    padfM As Long
    dfXMin As Double
    dfYMin As Double
    dfZMin As Double
    dfMMin As Double
    dfXMax As Double
    dfYMax As Double
    dfZMax As Double
    dfMMax As Double
End Type

Public Enum DBFFieldType
  FTString
  FTInteger
  FTDouble
  FTLogical
  FTInvalid
End Enum

Public Const XBASE_FLDHDR_SZ = 32

Public Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" (pDest As Any, pSource As Any, ByVal dwLength As Long)

Public Declare Function DBFAddField Lib "shapelib.dll" (ByVal hDBF As Long, ByVal pszFieldName As String, ByVal eType As DBFFieldType, ByVal nWidth As Long, ByVal nDecimals As Long) As Long
Public Declare Function DBFCloneEmpty Lib "shapelib.dll" (ByVal psDBF As Long, ByVal pszFilename As String) As Long
Public Declare Function DBFCreate Lib "shapelib.dll" (ByVal pszDBFFile As String) As Long
Public Declare Function DBFGetFieldCount Lib "shapelib.dll" (ByVal psDBF As Long) As Long
Public Declare Function DBFGetFieldIndex Lib "shapelib.dll" (ByVal psDBF As Long, ByVal pszFieldName As String) As Long
Public Declare Function DBFGetFieldInfo Lib "shapelib.dll" (ByVal psDBF As Long, ByVal iField As Long, ByVal pszFieldName As String, ByVal pnWidth As Long, ByVal pnDecimals As Long) As DBFFieldType
Public Declare Function DBFGetNativeFieldType Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iField As Long) As String
Public Declare Function DBFGetRecordCount Lib "shapelib.dll" (ByVal psDBF As Long) As Long
Public Declare Function DBFIsAttributeNULL Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As Long
Public Declare Function DBFOpen Lib "shapelib.dll" (ByVal pszDBFFile As String, ByVal pszAccess As String) As Long
Public Declare Function DBFReadDoubleAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As Long
Public Declare Function DBFReadIntegerAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As Long
Public Declare Function DBFReadLogicalAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As String
Public Declare Function DBFReadStringAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As String
Public Declare Function DBFReadTuple Lib "shapelib.dll" (ByVal psDBF As Long, ByVal hEntity As Long) As String
Public Declare Function DBFWriteAttributeDirectly Lib "shapelib.dll" (ByVal psDBF As Long, ByVal hEntity As Long, ByVal iField As Long, ByVal pValue As Any) As Long
Public Declare Function DBFWriteDoubleAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long, ByVal dFieldValue As Double) As Long
Public Declare Function DBFWriteIntegerAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long, ByVal nFieldValue As Long) As Long
Public Declare Function DBFWriteLogicalAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long, ByVal sFieldValue As String) As Long
Public Declare Function DBFWriteNULLAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long) As Long
Public Declare Function DBFWriteStringAttribute Lib "shapelib.dll" (ByVal hDBF As Long, ByVal iShape As Long, ByVal iField As Long, ByVal pszFieldValue As String) As Long
Public Declare Function DBFWriteTuple Lib "shapelib.dll" (ByVal psDBF As Long, ByVal hEntity As Long, ByVal pRawTuple As Any) As Long
Public Declare Function SHPCreate Lib "shapelib.dll" (ByVal pszShapeFile As String, ByVal nShapeType As Long) As Long
Public Declare Function SHPCreateObject Lib "shapelib.dll" (ByVal nSHPType As Long, ByVal nShapeId As Long, _
    ByVal nParts As Long, ByVal panPartStart As Long, ByVal panPartType As Long, ByVal nVertices As Long, _
    ByVal padfX As Long, ByVal padfY As Long, ByVal padfZ As Long, ByVal padfM As Long) As Long
Public Declare Function SHPCreateSimpleObject Lib "shapelib.dll" (ByVal nSHPType As Long, ByVal nVertices As Long, _
    ByVal padfX As Long, ByVal padfY As Long, ByVal padfZ As Long) As Long
Public Declare Function SHPOpen Lib "shapelib.dll" (ByVal pszShapeFile As String, ByVal pszAccess As String) As Long
Public Declare Function SHPPartTypeName Lib "shapelib.dll" (ByVal nPartType As Long) As String
Public Declare Function SHPReadObject Lib "shapelib.dll" (ByVal hShp As Long, ByVal iShape As Long) As Long
Public Declare Function SHPRewindObject Lib "shapelib.dll" (ByVal hShp As Long, psObject As SHPObject) As Long
Public Declare Function SHPTypeName Lib "shapelib.dll" (ByVal nSHPType As Long) As String
Public Declare Function SHPWriteObject Lib "shapelib.dll" (ByVal hShp As Long, ByVal iShape As Long, psObject As SHPObject) As Long
Public Declare Sub DBFClose Lib "shapelib.dll" (ByVal hDBF As Long)
Public Declare Sub SHPClose Lib "shapelib.dll" (ByVal hShp As Long)
Public Declare Sub SHPComputeExtents Lib "shapelib.dll" (psObject As SHPObject)
Public Declare Sub SHPDestroyObject Lib "shapelib.dll" (psObject As SHPObject)
Public Declare Sub SHPGetInfo Lib "shapelib.dll" (ByVal hShp As Long, ByVal pnEntities As Long, ByVal pnShapeType As Long, ByVal padfMinBound As Double, ByVal padfMaxBound As Double)

