﻿Public Class Form1


    Public Sub LoadBoundary(ByVal BoundaryFileName As String)
        Dim hShp As IntPtr = SHPDLL.SHPOpen(BoundaryFileName, "rb")
        If hShp = Nothing Then Exit Sub


        'get shape info and verify shapes were created correctly
        Dim minB As Double() = New Double(3) {}
        Dim maxB As Double() = New Double(3) {}
        Dim nEntities As Integer = 0
        Dim TheShapeType As SHPDLL.ShapeType = 0
        SHPDLL.SHPGetInfo(hShp, nEntities, TheShapeType, minB, maxB)

        'MsgBox(nEntities & vbCrLf & TheShapeType & vbCrLf & minB(0) & ", " & minB(1) & vbCrLf & maxB(0) & ", " & maxB(1))

        If TheShapeType = SHPDLL.ShapeType.Polygon And nEntities > 0 Then 'We know its a polygon
            For iShape = 0 To nEntities - 1
                'test SHPReadObject on the first shape
                Dim pshpObj As IntPtr = SHPDLL.SHPReadObject(hShp, iShape)

                'Get the SHPObject associated with our IntPtr pshpObj
                'We create a new SHPObject in managed code, then use Marshal.PtrToStructure
                'to copy the unmanaged memory pointed to by pshpObj into our managed copy.
                Dim shpObj As New SHPDLL.SHPObject()
                System.Runtime.InteropServices.Marshal.PtrToStructure(pshpObj, shpObj)


                'Recover the vertices for this shape. Use Marshal.Copy to copy the memory pointed
                'to by shpObj.padfX and shpObj.padfX (each an IntPtr) to an actual array.
                Dim xCoord As Double() = New Double(shpObj.nVertices - 1) {}
                Dim yCoord As Double() = New Double(shpObj.nVertices - 1) {}
                System.Runtime.InteropServices.Marshal.Copy(shpObj.padfX, xCoord, 0, shpObj.nVertices)
                System.Runtime.InteropServices.Marshal.Copy(shpObj.padfY, yCoord, 0, shpObj.nVertices)
                Dim ThisLat As Double
                Dim ThisLon As Double

                Dim partcount As Integer = shpObj.nParts
                Dim partstartlist As Integer() = New Integer(partcount - 1) {}
                System.Runtime.InteropServices.Marshal.Copy(shpObj.paPartStart, partstartlist, 0, partcount)
                
                Dim vertexcount As Integer = shpObj.nVertices - 1 'Make this a 0 based number

                Dim parts(1, partcount - 1) As Integer
                parts(0, 0) = 0
                parts(1, partcount - 1) = vertexcount
                If partcount > 1 Then
                    For i = 2 To partcount
                        parts(1, i - 2) = partstartlist(i - 1) - 1
                        parts(0, i - 1) = partstartlist(i - 1)
                    Next

                    Dim a1 As Integer = parts(0, 0)
                    Dim a2 As Integer = parts(1, 0)
                    Dim b1 As Integer = parts(0, 1)
                    Dim b2 As Integer = parts(1, 1)
                End If



                If vertexcount > 2 Then
                    If iShape = 0 Then
                        ''First point, light up the section control button
                        'If MainForm.LineBottom.Visible = True Then
                        '    'Form has opened
                        '    MainForm.btnSectionControl.Visible = True
                        'End If
                    Else
                        'Not the first object, set first point to transparent
                        AppendBoundaryPoint(yCoord(0), xCoord(0), True, True)
                    End If


                    For n As Integer = 0 To parts(1, 0) 'This is the outer ring
                        ' the X Field should be Longitude and the Y Field should be Latitude.

                        ThisLon = xCoord(n)
                        ThisLat = yCoord(n)

                        'If Not bWGS84 Then
                        '    'I actually have an X value in longitude !!!!
                        '    Dim x As Double = mlatlon.dlon
                        '    Dim y As Double = mlatlon.dlat
                        '    UTMXYToLatLon(x, y, iZone, southhemi, mlatlon.dlat, mlatlon.dlon)
                        'End If

                        'MsgBox(ThisLat & vbCrLf & ThisLon)
                        AppendBoundaryPoint(ThisLat, ThisLon, True, False)
                    Next




                    'Always set last point as transparent on the map
                    AppendBoundaryPoint(yCoord(parts(1, 0)), xCoord(parts(1, 0)), True, True)

                    If partcount > 1 Then 'Now we do the inner rings
                        For i = 1 To partcount - 1
                            If parts(1, i) - parts(0, i) > 2 Then
                                AppendBoundaryPoint(yCoord(parts(0, i)), xCoord(parts(0, i)), False, True)
                                For j = parts(0, i) To parts(1, i)
                                    AppendBoundaryPoint(yCoord(j), xCoord(j), False, False)
                                Next
                                AppendBoundaryPoint(yCoord(parts(1, i)), xCoord(parts(1, i)), False, True)
                            End If
                        Next
                    End If
                End If

                shpObj = Nothing
                SHPDLL.SHPDestroyObject(pshpObj)
            Next
        End If
        SHPDLL.SHPClose(hShp)
    End Sub



    Public Sub AppendBoundaryPoint(ByVal PointLat As Double, ByVal PointLon As Double, ByVal Perimeter As Boolean, ByVal Transparent As Boolean)
        'This is where you would translate the lat/lon of these points to lines in your coordinate system.
        'The Perimeter option is so you know if this is an outer or inner ring, if that matters to you.
        'I deal with DirectX, so I have lines connecting the rings. The connecting lines are transparent so the user doesn't see them on the screen.
    End Sub

End Class
